unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, jpeg, ExtCtrls, Menus, ImgList, Buttons, ToolWin, ComCtrls, StrUtils;

type
  TForm1 = class(TForm)
    Image1: TImage;
    OpenDialog1: TOpenDialog;
    SaveDialog1: TSaveDialog;
    MainMenu1: TMainMenu;
    Plik1: TMenuItem;
    Otwrz1: TMenuItem;
    Zapiszjako1: TMenuItem;
    Zakocz1: TMenuItem;
    N1: TMenuItem;
    ImageList1: TImageList;
    StatusBar1: TStatusBar;
    Obraz1: TMenuItem;
    Negatyw1: TMenuItem;
    Negatyw2: TMenuItem;
    Negatyw3: TMenuItem;
    Drukuj1: TMenuItem;
    N2: TMenuItem;
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure Drukuj1Click(Sender: TObject);
    procedure Negatyw3Click(Sender: TObject);
    procedure Negatyw2Click(Sender: TObject);
    procedure Negatyw1Click(Sender: TObject);
    procedure Zakocz1Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormKeyDown(Sender: TObject; var Key: Word; Shift: TShiftState);
    procedure Image1DblClick(Sender: TObject);
    {dodane samodzielnie}
    procedure ZapiszObrazDoPliku(Sender: TObject);
  private
    { Private declarations }
    procedure WczytywaniePlikuZListyWMenu(Sender: TObject);
    procedure UzupelnianieListyPlikowWMenu(NazwaPliku :String);
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

uses Drukowanie, Rejestr;

{$R *.dfm}

procedure KopiujJpegDoBitmap(Image :TImage);
var jpeg :TJPEGImage;
begin
//nie mozna tego zrobic z wmf
if Image.Picture.Graphic is TJPEGImage then
  begin
  jpeg:=TJPEGImage.Create;
  jpeg.Assign(Image.Picture.Graphic);
  Image.Picture.Bitmap.Assign(jpeg);
  jpeg.Free;
  end;
end;

procedure TForm1.Drukuj1Click(Sender: TObject);
var marginesy :TMarginesy;
begin
marginesy.Lewy:=500;
marginesy.Prawy:=500;
marginesy.Gorny:=500;
marginesy.Dolny:=500;
Drukuj(Image1.Picture.Graphic,True,False,marginesy);
end;

procedure TForm1.FormClose(Sender: TObject; var Action: TCloseAction);
const IloscStalychPozycjiMenuPlik=6;
var
  i: Integer;
  ListaPlikow :TStringList;
begin
ZapiszUstawieniaOkna(Self,'\Software\Helion\Oko\Okno',False);

//zapisywanie listy plikow
ListaPlikow:=TStringList.Create;
for i:=IloscStalychPozycjiMenuPlik to Plik1.Count-1 do
  ListaPlikow.Add(Plik1.Items[i].Caption);
ZapiszListePlikow('\Software\Helion\Oko\Pliki',True,ListaPlikow);
end;

procedure TForm1.UzupelnianieListyPlikowWMenu(NazwaPliku :String);
const IloscStalychPozycjiMenuPlik=6;
var PozycjaMenu :TMenuItem;
begin
Plik1.AutoHotkeys:=maManual;
//przygotowanie pozycji menu
PozycjaMenu:=TMenuItem.Create(Self);
PozycjaMenu.Caption:=NazwaPliku;
PozycjaMenu.OnClick:=WczytywaniePlikuZListyWMenu;
//dodawanie pozycji; pomijam sprawdzanie, czy istnieje juz taka sama pozycja
Plik1.Insert(IloscStalychPozycjiMenuPlik,PozycjaMenu);
//usuwanie nadwyzkowych pozycji
while Plik1.Count-IloscStalychPozycjiMenuPlik>10 do
  Plik1.Items[Plik1.Count-1].Free;
//nie ma zwalniania obiektu, bo on pozostaje w menu
end;

procedure TForm1.WczytywaniePlikuZListyWMenu(Sender: TObject);
var NazwaPliku :String;
begin
NazwaPliku:=(Sender as TMenuItem).Caption;
AnsiReplaceStr(NazwaPliku,'&','');
try
  Image1.Picture.LoadFromFile(NazwaPliku);
  KopiujJpegDoBitmap(Image1);
  Form1.Caption:=NazwaPliku;
  StatusBar1.Panels[0].Text:=ExtractFileName(NazwaPliku);
  StatusBar1.Panels[1].Text:=IntToStr(Image1.Picture.Width)+' x '+IntToStr(Image1.Picture.Height);
except
  ShowMessage('Wczytanie pliku '+NazwaPliku+' nie powiodo si!');
end;
end;

procedure TForm1.FormCreate(Sender: TObject);
var
  NazwaPliku :String;
  ListaPlikow :TStringList;
  NazwaPlikuZListy :String;
begin
CzytajUstawieniaOkna(Self,'\Software\Helion\Oko\Okno',False);

ListaPlikow:=TStringList.Create;
CzytajListePlikow('\Software\Helion\Oko\Pliki',False,ListaPlikow);
for NazwaPlikuZListy in ListaPlikow do
  UzupelnianieListyPlikowWMenu(NazwaPlikuZListy);
ListaPlikow.Free;

if ParamCount>0 then
  begin
  NazwaPliku:=ParamStr(1);
  if FileExists(NazwaPliku) then
    begin
    Image1.Picture.LoadFromFile(NazwaPliku);
    KopiujJpegDoBitmap(Image1);
    Self.Caption:=NazwaPliku;
    StatusBar1.Panels[0].Text:=ExtractFileName(NazwaPliku);
    StatusBar1.Panels[1].Text:=IntToStr(Image1.Picture.Width)+' x '+IntToStr(Image1.Picture.Height);
    UzupelnianieListyPlikowWMenu(NazwaPliku);
    end
    else ShowMessage('Plik '+NazwaPliku+' nie istnieje!');
  end;
end;

//metoda nie jest poczona ze zdarzeniem OnKeyDown
procedure TForm1.FormKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
case Key of
  VK_ESCAPE: Close();
  Ord('O'): Image1DblClick(Sender);
  Ord('S'): ZapiszObrazDoPliku(Sender);
end;
end;

procedure TForm1.Image1DblClick(Sender: TObject);
begin
if OpenDialog1.Execute then
  begin
  Image1.Picture.LoadFromFile(OpenDialog1.FileName);
  KopiujJpegDoBitmap(Image1);
  Form1.Caption:=OpenDialog1.FileName;
  StatusBar1.Panels[0].Text:=ExtractFileName(OpenDialog1.FileName);
  StatusBar1.Panels[1].Text:=IntToStr(Image1.Picture.Width)+' x '+IntToStr(Image1.Picture.Height);
  UzupelnianieListyPlikowWMenu(OpenDialog1.FileName);
  end;
end;

procedure TForm1.Negatyw1Click(Sender: TObject);
var
  x,y :Integer;
  r,g,b :Byte;
  kolor :TColor;
begin
Screen.Cursor:=crHourGlass;
for y:=0 to Image1.Picture.Bitmap.Height-1 do
for x:=0 to Image1.Picture.Bitmap.Width-1 do
  begin
  kolor:=Image1.Picture.Bitmap.Canvas.Pixels[x,y];
  r:=GetRValue(kolor);
  g:=GetGValue(kolor);
  b:=GetBValue(kolor);
  kolor:=RGB(255-r,255-g,255-b);
  Image1.Picture.Bitmap.Canvas.Pixels[x,y]:=kolor;
  end;
Screen.Cursor:=crDefault;
end;

procedure TForm1.Negatyw2Click(Sender: TObject);
var
  x,y :Integer;
  kolor :TColor;
begin
Screen.Cursor:=crHourGlass;
for y:=0 to Image1.Picture.Bitmap.Height-1 do
for x:=0 to Image1.Picture.Bitmap.Width-1 do
  begin
  kolor:=Image1.Picture.Bitmap.Canvas.Pixels[x,y];
  kolor:=(not kolor) and $00FFFFFF;
  Image1.Picture.Bitmap.Canvas.Pixels[x,y]:=kolor;
  end;
Screen.Cursor:=crDefault;
end;

procedure TForm1.Negatyw3Click(Sender: TObject);
var
  y :Integer;
  n :Integer;
  p : PByteArray;
  IloscBajtowWLinii :Integer;
begin
IloscBajtowWLinii:=Integer(Image1.Picture.Bitmap.ScanLine[0])-Integer(Image1.Picture.Bitmap.ScanLine[1]);
for y:=0 to Image1.Picture.Bitmap.Height-1 do
  begin
  p:=Image1.Picture.Bitmap.ScanLine[y];
  for n:=0 to IloscBajtowWLinii-1 do p[n]:=not p[n];
  end;
Refresh;
end;

procedure TForm1.Zakocz1Click(Sender: TObject);
begin
Close();
end;

procedure TForm1.ZapiszObrazDoPliku(Sender: TObject);
begin
SaveDialog1.DefaultExt:=ExtractFileExt(OpenDialog1.FileName);
SaveDialog1.Filename:=OpenDialog1.FileName;
if SaveDialog1.Execute then
  begin
  Image1.Picture.Graphic.SaveToFile(SaveDialog1.FileName);
  Form1.Caption:=SaveDialog1.FileName;
  end;
end;

end.
